/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.ActivityFileEvent;
import apiipc.generated.events.ActivityFileEventListener;
import apiipc.generated.system.ActivityFile;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityFileEventRegistry
extends IPCEventRegistry {
    protected Set<ActivityFileEventListener> globalListeners = new HashSet<ActivityFileEventListener>();
    protected Map<String, Set<ActivityFileEventListener>> specificObjectListeners = new HashMap<String, Set<ActivityFileEventListener>>();

    public ActivityFileEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "ActivityFile";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        ActivityFileEvent.PercentageCompleteChanged percentageCompleteChanged = null;
        if (!string.equalsIgnoreCase("percentageCompleteChanged")) {
            return;
        }
        percentageCompleteChanged = new ActivityFileEvent.PercentageCompleteChanged(iPCEventLTV);
        for (ActivityFileEventListener object : this.globalListeners) {
            object.handleEvent(percentageCompleteChanged);
        }
        Set<ActivityFileEventListener> set = this.specificObjectListeners.get(percentageCompleteChanged.objectUUID.toString());
        if (set != null) {
            for (ActivityFileEventListener activityFileEventListener : set) {
                activityFileEventListener.handleEvent(percentageCompleteChanged);
            }
        }
    }

    public void addListenerFiltered(ActivityFileEventListener activityFileEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("percentageCompleteChanged");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(activityFileEventListener);
    }

    public void addSpecificListenerFiltered(ActivityFileEventListener activityFileEventListener, ActivityFile activityFile, List<String> list) throws IOException {
        UUID uUID = activityFile.getObjectUUID();
        String string = uUID.toString();
        Set<ActivityFileEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<ActivityFileEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "percentageCompleteChanged");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(activityFileEventListener);
    }

    public void removeListenerFiltered(ActivityFileEventListener activityFileEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("percentageCompleteChanged");
            }
            this.globalListeners.remove(activityFileEventListener);
        }
    }

    public void removeSpecificListenerFiltered(ActivityFileEventListener activityFileEventListener, ActivityFile activityFile, List<String> list) throws IOException {
        UUID uUID = activityFile.getObjectUUID();
        String string = uUID.toString();
        Set<ActivityFileEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "percentageCompleteChanged");
            set.remove(activityFileEventListener);
        }
    }

    public void addListener(ActivityFileEventListener activityFileEventListener) throws IOException {
        this.addListenerFiltered(activityFileEventListener, null);
    }

    public void addListener(ActivityFileEventListener activityFileEventListener, ActivityFile activityFile) throws IOException {
        this.addSpecificListenerFiltered(activityFileEventListener, activityFile, null);
    }

    public void removeListener(ActivityFileEventListener activityFileEventListener) throws IOException {
        this.removeListenerFiltered(activityFileEventListener, null);
    }

    public void removeListener(ActivityFileEventListener activityFileEventListener, ActivityFile activityFile) throws IOException {
        this.removeSpecificListenerFiltered(activityFileEventListener, activityFile, null);
    }
}

